const Category = require('../Model').Categories
const Product = require('../Model').Products
const slugify = require('slugify');

exports.AddCategory = async (req, res) => {
    try {
        const { title } = req.body;
        if (!title) return res.json({ status: 40, msg: `Category title is required` });

        const catslug = slugify(title, { replacement: '_', lower: true });
        await Category.create({ title, slug: catslug });

        return res.json({ status: 200, msg: 'category created successfully' });
    } catch (error) {
        return res.json({ status: 400, msg: `error ${error}` });
    }
};

exports.UpdateCategory = async (req, res) => {
    try {
        const { title, id } = req.body;
        if (!title) return res.json({ status: 40, msg: `Category title is required` });

        const item = await Category.findOne({ where: { id: id } });
        if (!item) return res.json({ status: 400, msg: `category not found!.` });

        // Use slugify instead of slug
        const catslug = slugify(title, { replacement: '_', lower: true });
        item.title = title;
        item.slug = catslug;
        await item.save();

        return res.json({ status: 200, msg: 'category updated successfully' });
    } catch (error) {
        return res.json({ status: 400, msg: `error ${error}` });
    }
};

exports.DeleteCategory = async (req, res) => {
    try {
        const { id } = req.body;
        const cat = await Category.findByPk(id);
        if (!cat) return res.json({ status: 404, msg: `category not found` });

        const product = await Product.findAll({ where: { maincategory: cat.id } });
        if (product) {
            product.map(async (data) => {
                data.category = null;
                data.maincategory = null;
                await data.save();
            });
        }
        await cat.destroy();

        return res.json({ status: 200, msg: `Category Successfully Deleted!...` });
    } catch (error) {
        return res.json({ status: 400, msg: `error ${error}` });
    }
};

exports.AllCategory = async (req, res) => {
    try {
        const items = await Category.findAll({
            order: [['createdAt', 'DESC']],
        });
        return res.json({ status: 200, msg: items });
    } catch (error) {
        return res.json({ status: 400, msg: `error ${error}` });
    }
};

exports.SingleCategory = async (req, res) => {
    try {
        const { id } = req.params;
        const item = await Category.findOne({ where: { id: id } });
        if (!item) return res.json({ status: 400, msg: `category not found` });

        return res.json({ statsu: 200, msg: item });
    } catch (error) {
        return res.json({ status: 400, msg: `error ${error}` });
    }
};