const axios = require('axios');
const Payment = require('../Model').payments 

const PAYSTACK_SECRET_KEY = process.env.PAYSTACK_SECRET_KEY;

exports.initializePayment = async (req, res) => {
    const { email, amount } = req.body;
    try {
        const response = await axios.post(
            'https://api.paystack.co/transaction/initialize',
            { email, amount: amount * 100 },
            {
                headers: {
                    Authorization: `Bearer ${PAYSTACK_SECRET_KEY}`,
                    'Content-Type': 'application/json'
                }
            }
        );
        // Save payment to DB (Sequelize)
        await Payment.create({
            email,
            amount,
            reference: response.data.data.reference,
            status: 'pending'
        });
        res.json(response.data);
    } catch (error) {
        res.status(500).json({ error: error.response?.data || error.message });
    }
};

exports.verifyPayment = async (req, res) => {
    const { reference } = req.params;
    try {
        const response = await axios.get(
            `https://api.paystack.co/transaction/verify/${reference}`,
            {
                headers: {
                    Authorization: `Bearer ${PAYSTACK_SECRET_KEY}`
                }
            }
        );
        // Update payment status in DB (Sequelize)
        await Payment.update(
            { status: response.data.data.status },
            { where: { reference } }
        );
        res.json(response.data);
    } catch (error) {
        res.status(500).json({ error: error.response?.data || error.message });
    }
};