const { AddProduct, UpdateProduct, AllProduct, SingleProduct, DeleteProduct, AllProductsByCategory, DeleteProductImage, FetchProductForUpdating, RandomProducts, AddToWishlist, RemoveWishlist, GetWishlistByUser, GetWishlistProductById, } = require('../Controllers/product')
const { AdminRoute, UserRoute } = require('../Middleware/Auth')

const router = require('express').Router()

router.post('/create-product', AddProduct)
router.post('/update-product', UpdateProduct)
router.get('/fetch-update-product/:id', FetchProductForUpdating)
router.get('/get-product', AllProduct)
router.get('/get-single-product/:id', SingleProduct)
router.post('/delete-product', AdminRoute, DeleteProduct)
router.post('/delete-productimage', AdminRoute, DeleteProductImage)
router.get('/all-product-category/:cart', AllProductsByCategory)
router.get('/random-product', RandomProducts)
router.post('/add-wishlist', AddToWishlist)
router.get('/get-wishlist/:user', UserRoute, GetWishlistByUser)

module.exports = router