const User = require('../Model').Users
const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');
const fs = require('fs')
const GenerateOtp = require('otp-generator');
const MailSender = require('../Config/emailConfig');


exports.CreateUser = async (req, res) => {
    try {
        const { firstname, lastname, email, password, confirm_pass } = req.body
        if (!firstname) return res.json({ status: 400, msg: 'firstname is required' })
        if (!lastname) return res.json({ status: 400, msg: 'lastname is required' })
        if (!email) return res.json({ status: 400, msg: 'email is required' })
        if (!password) return res.json({ status: 400, msg: 'password is required' })
        if (password.length < 6) return res.json({ status: 400, msg: 'password is too short' })
        if (password !== confirm_pass) return res.json({ status: 400, msg: 'incorrect password detected ' })

        const checkUser = await User.findOne({ where: { email } })
        if (checkUser) {
            return res.json({ status: 400, msg: 'Email address already exist' })
        }

        const getSalt = await bcrypt.genSaltSync(10)
        const newpass = await bcrypt.hashSync(password, getSalt)

        const date = new Date()
        const OTP = GenerateOtp.generate(6, { specialChars: false })
        const refid = `${firstname.slice(-5)}_${OTP}${date.getTime()}`


        const newUser = { firstname, lastname, email, password: newpass, role: 'user', refid }
        const user = await User.create(newUser)
        const otp = GenerateOtp.generate(6, { specialChars: false, lowerCaseAlphabets: false })
        user.resetcode = otp
        await user.save()

        await MailSender(email, `This is your OTP Verification code <h1>${otp}</h1>`, 'Account Verification OTP')

        return res.json({ status: 200 })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })
    }
}

exports.AcceptRegistrationOtp = async (req, res) => {
    try {
        const { code } = req.body
        if (!code) return res.json({ status: 404, msg: `provide a Verification code` })
        const user = await User.findOne({ where: { resetcode: code } })
        if (!user) return res.json({ status: 404, msg: `Invalid Verification code` })
        user.resetcode = null
        user.email_verified = 'yes'
        await user.save()

        return res.json({ status: 200, msg: `Email Address Successfully verified` })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })
    }
}

exports.ResendOtp = async (req, res) => {
    try {
        const { email } = req.body
        const user = await User.findOne({ where: { email: email } })
        if (!user) return res.json({ status: 404, msg: `User Accound does not exists` })

        const OTP = GenerateOtp.generate(6, { specialChars: false })
        user.resetcode = OTP
        await user.save()
        // mailTo, subject, username, message, code, template
        await MailSender(email, 'Resend: Account registration Code', `${user.firstname}`, `Copy and paste your account verification code below`, OTP, 'verification')

        return res.json({ status: 200, msg: `Check yout Email,  a new code has been sent` })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })
    }
}

exports.GetSingleUser = async (req, res) => {
    try {
        const user = await User.findOne({ where: { id: req.user } })
        if (!user) return res.json({ status: 404, msg: `User not found` })

        return res.json({ status: 200, msg: user })
    } catch (error) {
        return res.json({ status: 400, msg: `Error: ${error}` })
    }
}
exports.LoginUser = async (req, res) => {
    try {
        const { email, password } = req.body
        if (!email) return res.json({ status: 400, msg: "email address is required" })
        if (!password) return res.json({ status: 400, msg: "Password is required" })

        const user = await User.findOne({ where: { email } })
        if (!user) return res.json({ status: 400, msg: "User not found" })

        const checkPass = await bcrypt.compareSync(password, user.password)
        if (!checkPass) return res.json({ status: 400, msg: "Password is incorrect" })

        user.status = 'online';
        await user.save();
        const token = jwt.sign({ id: user.id, role: user.role }, process.env.JWT_SECRET, { expiresIn: '1d' })

        return res.json({ status: 200, msg: 'User logged in successfully', token })
    } catch (error) {
        return res.json({ status: 400, msg: `Something went wrong ${error}` });
    }

}
exports.LogoutUser = async (req, res) => {
    try {
        const user = await User.findOne({ where: { id: req.user } })
        if (!user) return res.json({ status: 404, msg: `user not found` })
        user.status = 'offline';
        await user.save();
        const token = jwt.sign({}, process.env.JWT_SECRET, { expiresIn: '0s' })

        return res.json({ status: 200, msg: 'account logout successfully', })
    } catch (error) {
        return res.json({ status: 400, msg: `Something went wrong ${error}` });
    }
}


exports.GetAllUser = async (req, res) => {
    try {
        const items = await User.findAll({
            order: [['createdAt', 'DESC']],
        })

        return res.json({ status: 200, msg: items })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })

    }
}
exports.DeleteUser = async (req, res) => {
    try {
        const { id } = req.body
        const user = await User.findByPk(id)
        if (!user) return res.json({ status: 404, msg: `user not found` })
        await user.destroy()

        return res.json({ status: 200, msg: `User Successfully Deleted!...` })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })
    }
}

