const { Sequelize, DataTypes } = require('sequelize')
const dbConfig = require('../Config/dbConfig')

const sequelize = new Sequelize(
    dbConfig.DB,
    dbConfig.USER,
    dbConfig.PASSWORD, {
    host: dbConfig.HOST,
    dialect: dbConfig.dialect,
    operatorsAliases: false,
    pool: {
        max: dbConfig.pool.max,
        min: dbConfig.pool.min,
        acquire: dbConfig.pool.acquire,
        idle: dbConfig.pool.idle
    }
}
)

sequelize.authenticate()
    .then(() => console.log("server connected"))
    .catch((error) => console.log(`server error ${error}`))

const db = {}

db.sequelize = sequelize
db.Sequelize = Sequelize

db.Users = require('./user')(sequelize, DataTypes)
db.Products = require('./Product')(sequelize, DataTypes)
db.ProductImages = require('./productImage')(sequelize, DataTypes)
db.Categories = require('./category')(sequelize, DataTypes)
db.Admins = require('./admin')(sequelize, DataTypes)
db.orders = require('./order')(sequelize, DataTypes)
db.wishlists = require('./wishlist')(sequelize, DataTypes)
db.payments = require('./Payment')(sequelize, DataTypes)

//
db.Categories.hasMany(db.Products, { foreignKey: "maincategory", as: 'carts' })
db.Users.hasMany(db.wishlists, { foreignKey: "user", as: 'wishs' })
db.Products.hasMany(db.ProductImages, { foreignKey: 'product', as: 'images' })
//
db.Products.hasMany(db.orders, { foreignKey: 'product', as: 'orders' })
//
db.ProductImages.hasMany(db.orders, { foreignKey: 'image', as: 'productimage' })
//
db.Categories.hasMany(db.orders, { foreignKey: 'category', as: 'cartorder' })

//
db.Products.belongsTo(db.Categories, { foreignKey: 'maincategory', as: 'cart' })
db.wishlists.belongsTo(db.Users, { foreignKey: 'user', as: 'wish' })
db.ProductImages.belongsTo(db.Products, { foreignKey: 'product', as: 'images' })
//
db.orders.belongsTo(db.Products, { foreignKey: 'product', as: 'orders' })
db.orders.belongsTo(db.Categories, { foreignKey: 'category', as: 'cartorder' })
db.wishlists.belongsTo(db.Users, { foreignKey: 'user', as: 'userWish' }) // changed alias here
db.wishlists.belongsTo(db.Products, { foreignKey: 'product', as: 'productDetails' })

db.sequelize.sync({ force: false }).then(() => console.log('re-sync done.'))

module.exports = db