const Admin = require('../Model').Admins
const User = require('../Model').Users
const Category = require('../Model').Categories
const Product = require('../Model').Products
const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');



exports.CreateAdmin = async (req, res) => {
    try {
        const { firstname, lastname, email, phone, password, confirm_pass } = req.body
        if (!firstname) return res.json({ status: 400, msg: 'firstname is required' })
        if (!lastname) return res.json({ status: 400, msg: 'lastname is required' })
        if (!phone) return res.json({ status: 400, msg: 'phone is requireds' })
        if (!email) return res.json({ status: 400, msg: 'email is required' })
        if (!password) return res.json({ status: 400, msg: 'password is required' })
        if (password.length < 6) return res.json({ status: 400, msg: 'password is too short' })
        if (password !== confirm_pass) return res.json({ status: 400, msg: 'incorrect password detected ' })

        const checkAdmin = await Admin.findOne({ where: { email } })
        if (checkAdmin) {
            return res.json({ status: 400, msg: 'Email address already exist' })
        }
        const checkPhone = await Admin.findOne({ where: { phone } })
        if (checkPhone) {
            return res.json({ status: 400, msg: 'Phone number already exist' })
        }

        const getSalt = await bcrypt.genSaltSync(10)
        const newpass = await bcrypt.hashSync(password, getSalt)

        const newAdmin = { firstname, lastname, email, password: newpass, pass: password, phone, role: 'admin', }
        const admin = await Admin.create(newAdmin)


        const token = jwt.sign({ id: admin.id, role: admin.role }, process.env.JWT_SECRET, { expiresIn: '0.1d' })

        return res.json({ status: 200, msg: 'Admin created successfully', token })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })
    }
}

exports.UpdateAdmin = async (req, res) => {
    try {
        const { id } = req.body
        const { firstname, lastname, email, phone, password } = req.body;
        if (!firstname) return res.json({ status: 400, msg: `firstname is required` });
        if (!lastname) return res.json({ status: 400, msg: `lastname is required` });
        if (!email) return res.json({ status: 400, msg: `email is required` });
        if (!password) return res.json({ status: 400, msg: `password is required` });
        if (!phone) return res.json({ status: 400, msg: `phone is required` });

        const admin = await Admin.findOne({ where: { id: id }, });
        if (!admin) return res.json({ status: 400, msg: `admin not found` });

        admin.firstname = firstname
        admin.lastname = lastname;
        admin.email = email;
        admin.password = password;
        admin.phone = phone;
        await admin.save();

        return res.json({ status: 200, msg: `Admin Updated Successfully` });
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` });
    }
}

exports.GetSingleAdmin = async (req, res) => {
    try {
        const admin = await Admin.findOne({ where: { id: req.admin } })
        if (!admin) return res.json({ status: 404, msg: `admin not found` })

        return res.json({ status: 200, msg: admin })
    } catch (error) {
        return res.json({ status: 400, msg: `Error: ${error}` })
    }
}
exports.LoginAdmin = async (req, res) => {
    try {
        const { email, password } = req.body
        if (!email) return res.json({ status: 400, msg: "email address is required" })
        if (!password) return res.json({ status: 400, msg: "Password is required" })

        const admin = await Admin.findOne({ where: { email } })
        if (!admin) return res.json({ status: 400, msg: "admin not found" })

        const checkPass = await bcrypt.compareSync(password, admin.password)
        if (!checkPass) return res.json({ status: 400, msg: "Password is incorrect" })

        admin.status = 'online';
        await admin.save();
        const token = jwt.sign({ id: admin.id, role: admin.role }, process.env.JWT_SECRET, { expiresIn: '1d' })

        return res.json({ status: 200, msg: 'Admin logged in successfully', token })
    } catch (error) {
        return res.json({ status: 400, msg: `Something went wrong ${error}` });
    }

}
exports.LogoutAdmin = async (req, res) => {
    try {
        const admin = await Admin.findOne({ where: { id: req.admin } })
        if (!admin) return res.json({ status: 404, msg: `admin not found` })
        admin.status = 'offline';
        await admin.save();
        const token = jwt.sign({}, process.env.JWT_SECRET, { expiresIn: '0s' })

        return res.json({ status: 200, msg: 'account logout successfully' })
    } catch (error) {
        return res.json({ status: 400, msg: `Something went wrong ${error}` });
    }
}


exports.GetAllAdmin = async (req, res) => {
    try {
        const items = await Admin.findAll({
            order: [['createdAt', 'DESC']],
        })

        return res.json({ status: 200, msg: items })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })

    }
}
exports.DeleteAdmin = async (req, res) => {
    try {
        const { id } = req.body
        const admin = await Admin.findByPk(id)
        if (!admin) return res.json({ status: 404, msg: `admin not found` })
        await admin.destroy()

        return res.json({ status: 200, msg: `Admin Successfully Deleted!...` })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })
    }
}

exports.FeedAdminDashboard = async (req, res) => {
    try {
        const product = await Product.findAll({})
        const category = await Category.findAll({})
        const user = await User.findAll({})
        const admin = await Admin.findAll({})

        let items = [
            { tag: 'Products', total: product.length, bg: `green` },
            { tag: 'categories', total: category.length, bg: `teal` },
            { tag: 'users', total: user.length, bg: `cyan` },
            { tag: 'admin', total: admin.length, bg: `gold` },
        ]
        return res.json({ status: 200, msg: items })
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` })
    }
}

exports.ResendOTP = async (req, res) => {
    try {
        const { email } = req.body
        if (!email) return res.json({ status: 404, msg: `No Email Found` })
        const user = await User.findOne({ email: email })
        if (!user) return res.json({ status: 404, msg: `User doe not exists` })

        if (user.otp.nums === 3) {
            user.otp.trial = moment().add(1, 'days')
            return res.json({ status: 400, msg: `You cannot recieve mail again, retry again in the next 24 hours` })
        }

        const otpCode = GenerateOtp.generate(6, { specialChars: false, lowerCaseAlphabets: false })
        const timer = moment().add(1, 'minutes')

        const otp = {
            code: otpCode,
            expires: timer,
            nums: user.otp.nums + 1
        }

        user.otp = otp
        await user.save()

        await MailSender(email, `This is your OTP Verification code <h1>${otpCode}</h1>`, 'Resend: Account Verification OTP')


        return res.json({ status: 200, msg: `Mail sent successfully` })
    } catch (error) {
        return res.json({ status: 400, msg: `Something went wrong`, response: `${error}` })
    }
}

exports.ValidateAccountWithOtp = async (req, res) => {
    try {
        const { code, email } = req.body
        if (!code) return res.json({ status: 400, msg: `Provide a valid verification code` })
        const user = await User.findOne({ email: email })
        if (!user) return res.json({ status: 404, msg: `Invalid Account` })
        if (user.otp.code !== code) return res.json({ status: 400, msg: `Invalid verification code` })
        if (moment().isAfter(user.otp.expires)) return res.json({ status: 400, msg: `OTP Expired!..` })

        user.verified = true
        user.otp.code = null
        user.otp.expires = null
        await user.save()


        const token = jwt.sign({ id: user._id, role: user.role }, process.env.JWT_SECRET, { expiresIn: '1d' })

        return res.json({ status: 200, msg: `Account Created successfully`, token })
    } catch (error) {
        return res.json({ status: 400, msg: `something went wrong`, response: `${error}` })
    }
}
