const User = require('../Model').Users;
const Order = require('../Model').orders;

// Create order with status
exports.generateMultipleOrder = async (req, res) => {
    try {
        const { products, firstname, lastname, email, phone, country, state, address, town, total, paymenttype, reference } = req.body;
        if (!products) return res.json({ status: 400, msg: 'Products are required' });
        if (!firstname) return res.json({ status: 400, msg: 'firstname are required' });
        if (!lastname) return res.json({ status: 400, msg: 'lastname are required' });
        if (!email) return res.json({ status: 400, msg: 'email are required' });
        if (!paymenttype) return res.json({ status: 400, msg: 'paymenttype are required' });
        if (!phone) return res.json({ status: 400, msg: 'phone are required' });
        if (!country) return res.json({ status: 400, msg: 'country are required' });
        if (!state) return res.json({ status: 400, msg: 'state are required' });
        if (!address) return res.json({ status: 400, msg: 'address are required' });
        if (!town) return res.json({ status: 400, msg: 'town are required' });
        if (!total) return res.json({ status: 400, msg: 'total are required' });
        if (!reference) return res.json({ status: 400, msg: 'reference are required' });

        const checkEmail = await User.findOne({ where: { email: email } });
        if (!checkEmail) return res.json({ status: 400, msg: 'User not found with this email' });

        // Add status field, default to 'pending'
        const orders = await Order.create({
            products,
            firstname,
            lastname,
            email,
            phone,
            country,
            state,
            address,
            town,
            total,
            paymenttype,
            reference,
            status: 'pending',
            user: checkEmail.id
        });

        return res.json({ status: 200, msg: 'Order created Successfully!...', order: orders });
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` });
    }
};

// Get all orders (for user)
exports.GetAllOrders = async (req, res) => {
    try {
        const orders = await Order.findAll();
        return res.json({ status: 200, orders });
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` });
    }
};

// Update order status (e.g., after payment)
exports.UpdateOrderStatus = async (req, res) => {
    try {
        const { orderId, status } = req.body;
        if (!orderId || !status) return res.json({ status: 400, msg: 'orderId and status are required' });

        const order = await Order.findByPk(orderId);
        if (!order) return res.json({ status: 404, msg: 'Order not found' });

        order.status = status;
        await order.save();

        return res.json({ status: 200, msg: `Order Updated`, order });
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` });
    }
};

// Admin: Get all orders
exports.AdminGetAllOrders = async (req, res) => {
    try {
        const orders = await Order.findAll();
        return res.json({ status: 200, orders });
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` });
    }
};

// Admin: Get all tracks (if tracking implemented)
exports.AdmingetAllTracks = async (req, res) => {
    try {
        // Implement tracking logic if needed
        return res.json({ status: 200, msg: '' });
    } catch (error) {
        return res.json({ status: 400, msg: `Error ${error}` });
    }
};