const { CreateAdmin, LogoutAdmin, GetAllAdmin, LoginAdmin, DeleteAdmin, GetSingleAdmin, UpdateAdmin, FeedAdminDashboard } = require('../Controllers/admin')
const { AllRoutes, AdminRoute } = require('../Middleware/Auth')

const router = require('express').Router()

router.post('/create-admin', CreateAdmin)
router.post('/update-admin', UpdateAdmin)
router.post('/logout-admin', AdminRoute, LogoutAdmin)
router.get('/get-admin', GetAllAdmin)
router.get('/get-single-admin', AdminRoute, GetSingleAdmin)
router.post('/login-admin', LoginAdmin)
router.post('/delete-admin', AdminRoute, DeleteAdmin)
router.get('/stat-admin', FeedAdminDashboard)

module.exports = router