const express = require('express');
const cors = require('cors');
require('dotenv').config();
const fileUploader = require('express-fileupload');
// const compression = require('compression');

const App = express();
const port = process.env.PORT || 7000;
App.use(cors({
    origin: [
        'http://localhost:5173',
        'https://jocasualconcept.com.ng',
        'http://192.168.0.186:5173',
        'https://jocasual.netlify.app'
    ],
    methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
    credentials: true,
}));

App.use(express.json());
App.use(fileUploader());
App.use(express.static('public'));

// Routes
App.use('/api/user', require('./Routes/user'));
App.use('/api/admin', require('./Routes/admin'));
App.use('/api/category', require('./Routes/category'));
App.use('/api/product', require('./Routes/product'));
App.use('/api/payment', require('./Routes/payment'));
App.use('/api/order', require('./Routes/order'));

// Start the server
App.listen(port, () => {
    console.log(`Your server is running on http://localhost:${port}`);
});